/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.entity;

import io.netty.buffer.ByteBuf;
import java.util.List;
import javax.annotation.Nullable;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.api.util.FallingBlockManager;
import net.dries007.tfc.objects.blocks.stone.BlockOreTFC;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityFallingBlockTFC
extends EntityFallingBlock
implements IEntityAdditionalSpawnData {
    private FallingBlockManager.Specification currentSpecification;
    @SideOnly(value=Side.CLIENT)
    private IBlockState renderState;

    public EntityFallingBlockTFC(World world) {
        super(world);
    }

    public EntityFallingBlockTFC(World world, BlockPos pos, IBlockState fallingBlockState) {
        this(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), fallingBlockState);
    }

    public EntityFallingBlockTFC(World world, double x, double y, double z, IBlockState fallingBlockState) {
        super(world);
        TileEntity tile;
        this.currentSpecification = FallingBlockManager.getSpecification(fallingBlockState);
        this.field_175132_d = fallingBlockState;
        BlockPos pos = new BlockPos((Entity)this);
        if (this.currentSpecification.getResultingState() == null && (tile = this.field_70170_p.func_175625_s(pos)) != null) {
            this.field_145810_d = tile.serializeNBT();
        }
        this.field_70156_m = true;
        this.func_70105_a(0.98f, 0.98f);
        this.func_70107_b(x + 0.5, y + (double)((1.0f - this.field_70131_O) / 2.0f), z + 0.5);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
        this.func_184530_a(pos);
    }

    @Nullable
    public IBlockState func_175131_l() {
        return this.renderState == null ? this.field_175132_d : this.renderState;
    }

    public void func_70071_h_() {
        Block block = this.field_175132_d.func_177230_c();
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        BlockPos pos = new BlockPos((Entity)this);
        if (this.currentSpecification == null) {
            this.currentSpecification = FallingBlockManager.getSpecification(this.field_175132_d);
            if (this.currentSpecification == null) {
                this.func_70106_y();
                return;
            }
        }
        if (this.field_145812_b++ == 0) {
            IBlockState checkState = this.field_70170_p.func_180495_p(pos);
            if (FallingBlockManager.getSpecification(checkState) == this.currentSpecification) {
                this.field_70170_p.func_82736_K().func_82764_b("doTileDrops", Boolean.toString(false));
                this.field_70170_p.func_175698_g(pos);
                this.field_70170_p.func_175655_b(pos, false);
                this.field_70170_p.func_82736_K().func_82764_b("doTileDrops", Boolean.toString(true));
                if (!this.field_70170_p.field_72995_K) {
                    this.currentSpecification.beginFall(this.field_70170_p, pos);
                }
            } else if (!this.field_70170_p.field_72995_K) {
                this.func_70106_y();
                return;
            }
        }
        if (!this.func_189652_ae()) {
            this.field_70181_x -= (double)0.04f;
        }
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        if (!this.field_70170_p.field_72995_K) {
            if (!this.field_70122_E) {
                if (this.field_145812_b > 100 && (pos.func_177956_o() < 1 || pos.func_177956_o() > 256) || this.field_145812_b > 600) {
                    this.currentSpecification.endFall(this.field_70170_p, pos);
                    this.func_70106_y();
                    if (this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
                        this.dropItems(pos);
                    }
                }
            } else {
                IBlockState current = this.field_70170_p.func_180495_p(pos);
                Material material = this.currentSpecification.getResultingState(this.field_175132_d).func_185904_a();
                if (!current.func_177230_c().isAir(current, (IBlockAccess)this.field_70170_p, pos) && FallingBlockManager.canFallThrough(this.field_70170_p, pos, material, current)) {
                    this.field_70170_p.func_175655_b(pos, true);
                    return;
                }
                BlockPos downPos = pos.func_177977_b();
                IBlockState downState = this.field_70170_p.func_180495_p(downPos);
                if (!downState.func_177230_c().isAir(downState, (IBlockAccess)this.field_70170_p, downPos) && FallingBlockManager.canFallThrough(this.field_70170_p, downPos, material, downState)) {
                    this.field_70170_p.func_175655_b(downPos, true);
                    return;
                }
                if (ConfigTFC.General.FALLABLE.destroyOres && downState.func_177230_c() instanceof BlockOreTFC) {
                    this.field_70170_p.func_175655_b(downPos, false);
                    return;
                }
                this.field_70159_w *= (double)0.7f;
                this.field_70179_y *= (double)0.7f;
                this.field_70181_x *= -0.5;
                if (current.func_177230_c() != Blocks.field_180384_M) {
                    this.currentSpecification.endFall(this.field_70170_p, pos);
                    this.func_70106_y();
                    if (FallingBlockManager.canFallThrough(this.field_70170_p, pos, material, current)) {
                        TileEntity te;
                        this.field_70170_p.func_175655_b(pos, true);
                        this.field_70170_p.func_180501_a(pos, this.currentSpecification.getResultingState(this.field_175132_d), 3);
                        if (this.field_145810_d != null && block.hasTileEntity(this.field_175132_d) && (te = this.field_70170_p.func_175625_s(pos)) != null) {
                            NBTTagCompound currentTeData = te.func_189515_b(new NBTTagCompound());
                            for (String s : this.field_145810_d.func_150296_c()) {
                                if ("x".equals(s) || "y".equals(s) || "z".equals(s)) continue;
                                currentTeData.func_74782_a(s, this.field_145810_d.func_74781_a(s).func_74737_b());
                            }
                            te.func_145839_a(currentTeData);
                            te.func_70296_d();
                        }
                    } else if (this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
                        this.dropItems(pos);
                    }
                }
            }
        }
        this.field_70159_w *= (double)0.98f;
        this.field_70181_x *= (double)0.98f;
        this.field_70179_y *= (double)0.98f;
    }

    private void dropItems(BlockPos pos) {
        this.currentSpecification.getDrops(this.field_70170_p, pos, this.currentSpecification.getResultingState(this.field_175132_d), this.field_145810_d, this.field_145812_b, this.field_70143_R).forEach(x -> this.func_70099_a((ItemStack)x, 0.0f));
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ());
        for (Entity entity : list) {
            if (ConfigTFC.General.FALLABLE.hurtEntities && distance > 1.0f && entity instanceof EntityLivingBase) {
                entity.func_70097_a(DamageSource.field_82729_p, distance);
                continue;
            }
            if (!ConfigTFC.General.FALLABLE.destroyItems || !(entity instanceof EntityItem)) continue;
            entity.func_70106_y();
        }
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("State", Block.func_176210_f((IBlockState)(this.field_175132_d == null ? Blocks.field_150350_a.func_176223_P() : this.field_175132_d)));
        compound.func_74768_a("Time", this.field_145812_b);
        if (this.field_145810_d != null) {
            compound.func_74782_a("TileEntityData", (NBTBase)this.field_145810_d);
        }
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.field_175132_d = Block.func_176220_d((int)compound.func_74762_e("State"));
        this.field_145812_b = compound.func_74762_e("Time");
        this.field_145813_c = true;
        if (compound.func_150297_b("TileEntityData", 10)) {
            this.field_145810_d = compound.func_74775_l("TileEntityData");
        }
    }

    public void writeSpawnData(ByteBuf buffer) {
        if (this.field_175132_d != null) {
            buffer.writeBoolean(true);
            buffer.writeInt(Block.func_176210_f((IBlockState)this.field_175132_d));
        } else {
            buffer.writeBoolean(false);
        }
    }

    public void readSpawnData(ByteBuf additionalData) {
        if (additionalData.readBoolean()) {
            this.field_175132_d = Block.func_176220_d((int)additionalData.readInt());
            this.renderState = FallingBlockManager.getSpecification(this.field_175132_d).getResultingState(this.field_175132_d);
        }
    }

    public String func_70005_c_() {
        return I18n.func_135052_a((String)"entity.falling_block.name", (Object[])new Object[]{this.field_175132_d.func_177230_c().func_149732_F()});
    }
}

